#ifndef _AUDIOSOURCEFACTORY_H_
#define _AUDIOSOURCEFACTORY_H_
#include "osal_if.h"
// needed includes
#include "AudioStack/clAudioSource.h"
#include "AudioStack/AudioSources.h"


#ifdef _BOSCH_DIAG_KDS_
#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"
#endif

#ifndef _DO_NOT_USE_BOSCH_OSAL_
#define SYSTEM_S_IMPORT_INTERFACE_MAP
#define SYSTEM_S_IMPORT_INTERFACE_ALGORITHM
#include <stl_pif.h>
#else
#include <map>
#endif

// see precompiled.hh    #define TRACE_WITHOUT_OSAL
#define USE_DEBUG_INTERFACE
// see precompiled.hh    #include "hmicca_pif.h"

namespace AudioStack
{



class clAudioSourceFactory
{
private:
  clAudioSourceFactory();
   ~clAudioSourceFactory(){};

   /**
    * Map of AudioSources
    * Key is the AudioSource Enumeration that identifies to
    * Object, that is the Value of this map.
    */
   static bpstl::map<SourceID, clAudioSource*> audioSourceMap;
   static tU8 SourceObjectCounter;
   static clAudioSource* createAudioSourceObj(SourceID audioSource);

#ifdef _BOSCH_DIAG_KDS_
   static tBool bGetKDSEntry(tsKDSEntry *prKDSEntry);
#endif

public:
   static tVoid Init();
   static tVoid ListSources();
   static AudioSources::enAudioSources mapVirtualToLogicalSource(AudioSources::enAudioSources audioSource);
   static tVoid  resetAudioSources();

   /**
    * Deletes AudioSource
    */
   static tVoid removeAudioSources(SourceID srcID);
   /**
    * Returns an Instance of AudioSource if possible
    * it will create an Instance if there hasn't been
    * already created one
    * return NULL if source is not allowed or available
    */
   static clAudioSource* getAudioSource(AudioSources::enAudioSources audioSourceClass, tU8 SubSourceID=0);
   /**
    * Returns an Instance of AudioSource if possible
    * it will create an Instance if there hasn't been
    * already created one
    * return NULL if source is not allowed or available
    */
   static clAudioSource* getAudioSource(SourceID audioSource);
   /**
    * returns a available AudioSource of given SourceClass,
    * or NULL if none of the class is available
    */
   static clAudioSource* getAvailableAudioSource(AudioSources::enAudioSources sourceClass);
   static clAudioSource* getAvailableAudioSource();
   /**
    * Check if Source is valid.
    * It returns true if a corresponding StackRule is found.
    */
   static tBool isValidSourceClass(AudioSources::enAudioSources audioSource);

   /**
    * Check if the source was already instantiated
    * returns NULL if the source was not instantiated before
    */
   static clAudioSource* isSourceInstantiated(SourceID srcId);

   static tVoid deleteInstances();
};

}//namespace

#endif // _AUDIOSOURCEFACTORY_H_
